<?php
session_start();
include "config.php";

if (!isset($_SESSION['admin'])) {
    header("Location: admin_login.php");
    exit();
}

$total_query = $conn->query("SELECT COUNT(*) as total FROM subscribers");
$total = $total_query->fetch_assoc()["total"];

$online_query = $conn->query("SELECT COUNT(*) as total FROM subscribers WHERE status = 'online'");
$online = $online_query->fetch_assoc()["total"];

$offline_query = $conn->query("SELECT COUNT(*) as total FROM subscribers WHERE status = 'offline'");
$offline = $offline_query->fetch_assoc()["total"];

$debts_query = $conn->query("SELECT COUNT(*) as total FROM subscribers WHERE debt > 0");
$debts = $debts_query->fetch_assoc()["total"];

$agents_query = $conn->query("SELECT COUNT(*) as total FROM agents");
$agents = $agents_query->fetch_assoc()["total"];
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة إدارة الغدير</title>
    <style>
        body { font-family: Arial; background: #f7f7f7; text-align: center; padding: 20px; }
        .container { display: flex; justify-content: center; flex-wrap: wrap; gap: 20px; }
        .card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 0 10px #ccc;
            width: 200px;
        }
        h2 { margin: 0; color: #007BFF; }
        h3 { margin: 10px 0 0; font-size: 16px; }
        a { display: block; margin-top: 30px; color: #007BFF; text-decoration: none; }
    </style>
</head>
<body>
    <h1>أهلاً بك في لوحة التحكم يا <?php echo $_SESSION['admin']; ?>!</h1>
    <div class="container">
        <div class="card">
            <h2><?php echo $debts; ?></h2>
            <h3>مشتركين عليهم ديون</h3>
        </div>
        <div class="card">
            <h2><?php echo $offline; ?></h2>
            <h3>غير متصلين</h3>
        </div>
        <div class="card">
            <h2><?php echo $online; ?></h2>
            <h3>المتصلين الآن</h3>
        </div>
        <div class="card">
            <h2><?php echo $total; ?></h2>
            <h3>عدد المشتركين</h3>
        </div>
        <div class="card">
            <h2><?php echo $agents; ?></h2>
            <h3>عدد الوكلاء</h3>
        </div>
    </div>
    <a href="logout.php">تسجيل الخروج</a>
</body>
</html>
