<?php
require 'db_config.php';
$type = 'all'; // all / online / offline / debts

// SQL بناء الاستعلام حسب نوع الصفحة
switch ($type) {
  case 'online':
    $query = "SELECT * FROM subscribers WHERE connected = 1";
    break;
  case 'offline':
    $query = "SELECT * FROM subscribers WHERE connected = 0";
    break;
  case 'debts':
    $query = "SELECT * FROM subscribers WHERE debt > 0";
    break;
  default:
    $query = "SELECT * FROM subscribers";
}

$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>قائمة المشتركين</title>
  <style>
    body { font-family: 'Cairo', sans-serif; background: #f5f6fa; padding: 2rem; direction: rtl; }
    h2 { color: #1e3a8a; margin-bottom: 1rem; }
    table { width: 100%; border-collapse: collapse; background: white; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
    th { background-color: #f2f2f2; }
  </style>
</head>
<body>
  <h2>جميع المشتركين</h2>
  <table>
    <thead>
      <tr>
        <th>اسم الدخول</th><th>الاسم الكامل</th><th>الباقة</th>
        <th>تاريخ الانتهاء</th><th>المدة المتبقية</th>
        <th>IP</th><th>MAC</th><th>اتصال</th><th>ديون</th>
      </tr>
    </thead>
    <tbody>
    <?php while($row = $result->fetch_assoc()): ?>
      <tr>
        <td><?= $row['username'] ?? '' ?></td>
        <td><?= $row['fullname'] ?? '' ?></td>
        <td><?= $row['plan'] ?? '' ?></td>
        <td><?= $row['expire_date'] ?? '' ?></td>
        <td><?= $row['remaining'] ?? '' ?></td>
        <td><?= $row['ip'] ?? '' ?></td>
        <td><?= $row['mac'] ?? '' ?></td>
        <td><?= ($row['connected'] ?? 0) ? '🟢 متصل' : '🔴 غير متصل' ?></td>
        <td><?= ($row['debt'] ?? 0) ?> $</td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
</body>
</html>
